define(function () {

    var elementClickKey = '_vueDismissClick';
    var elementKeyupKey = '_vueDismissKeyup';
    function setup(el, binding) {
        var callback, shouldBind;
        if (typeof binding.value === 'function') {
            callback = binding.value;
            shouldBind = true;
        }
        else {
            callback = binding.value.callback;
            shouldBind = binding.value.hasOwnProperty('watch')
                ? Boolean(binding.value.watch)
                : true;
        }
        if (shouldBind) {
            if (typeof document !== 'undefined' && !el[elementClickKey]) {
                var handler_1 = function (event) {
                    if (event.keyCode) {
                        event.keyCode === 27 && callback();
                    }
                    else if (!(event.target === el) && !el.contains(event.target)) {
                        callback();
                    }
                };
                setTimeout(function () {
                    document.addEventListener('click', handler_1);
                    document.addEventListener('keyup', handler_1);
                }, 10);
                el[elementClickKey] = el[elementKeyupKey] = handler_1;
            }
        }
        else {
            unbind(el);
        }
    }
    function unbind(el) {
        if (el[elementClickKey] && typeof document !== 'undefined') {
            document.removeEventListener('click', el[elementClickKey]);
            document.removeEventListener('keyup', el[elementKeyupKey]);
            delete el[elementClickKey];
            delete el[elementKeyupKey];
        }
    }
    var vueDismiss = {
        directives: {
            onDismiss: {
                bind: setup,
                update: setup,
                unbind: unbind
            }
        }
    };

    var component = {
        mixins: [vueDismiss],
        components: {},
        data: function () {
            return {
                menuVisible: false
            };
        },
        created: function () {
            var _this = this;
            this.getMenu().then(function (result) {
                _this.menu = result;
            });
        },
        computed: {},
        methods: {
            showHideMenu: function () {
                this.menuVisible = !this.menuVisible;
            },
            topItemClick: function (item) {
                return function (event) {
                    var activeClass = "active";
                    if (event.target.parentElement.classList && event.target.parentElement.classList.contains(activeClass)) {
                        event.target.parentElement.classList.remove(activeClass);
                    }
                    else {
                        event.target.parentElement.classList.add(activeClass);
                    }
                };
            }
        }
    };

    var mobilemenu = /*#__PURE__*/Object.freeze({
        __proto__: null,
        'default': component
    });

    function getCjsExportFromNamespace (n) {
    	return n && n['default'] || n;
    }

    var require$$0 = getCjsExportFromNamespace(mobilemenu);

    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //
    //

    var mobilemenu_vue_rollupPluginVue_script = require$$0;

    mobilemenu_vue_rollupPluginVue_script.originalTemplate = "mobilemenu";
    mobilemenu_vue_rollupPluginVue_script.template = `
<div data-v-59b28c75 class="mobilemenu" v-on-dismiss="{watch: menuVisible, callback: () => showHideMenu() }">
  <div data-v-59b28c75 class="toggle-button" v-touch:tap="showHideMenu">        
    <img data-v-59b28c75 class="toggle-icon" src="./mobilemenu-icon.svg">
  </div>
  <transition data-v-59b28c75 name="fade">
    <div data-v-59b28c75 class="foldout fade" v-if="menuVisible">        
      <ul data-v-59b28c75 class="topitem-list">          
        <li data-v-59b28c75 class="topitem-listitem" v-for="topItem in menu.children" :key="topItem" >
          <div data-v-59b28c75 class="topitem-listitem-text" v-touch:tap="topItemClick(topItem)">
            {{topItem.title}}
          </div>
          <ul data-v-59b28c75 class="column-list">
            <li data-v-59b28c75 class="item-listitem" >                                 
              <h3 data-v-59b28c75 class="link link-topitem" v-if="!topItem.value.href">{{topItem.translatedTitle || topItem.title}}</h3>
              <a data-v-59b28c75 class="link link-topitem" v-else-if="topItem.value.href" :href="topItem.value.href" :target="topItem.value.openInNewWindow ? '_blank':''" ><h3 data-v-59b28c75>{{topItem.translatedTitle || topItem.title}}</h3></a>
            </li>
            <li data-v-59b28c75 class="column-listitem" v-for="column in topItem.children" :key="column">
              <ul data-v-59b28c75 class="item-list">
                <li data-v-59b28c75 class="item-listitem" v-for="item in column.children" :key="item">
                  <div data-v-59b28c75 class="item-type item-type-heading"  v-if="item.contentType == 'Heading'">
                    <span data-v-59b28c75 v-if="item.title == ''" class="emptyHeading">&nbsp;</span>
                    <a data-v-59b28c75 
                      v-if="item.title != '' && item.contentType === 'Link'" 
                      :target="item.value.openInNewWindow ? '_blank':''" 
                      :data-interception="item.value.openInNewWindow ? 'off' : ''" 
                      :href="(item.translatedValue && item.translatedValue.href) ? item.translatedValue.href : item.value.href" 
                      class="link"
                    >
                      <h3 data-v-59b28c75>{{item.translatedTitle || item.title}}</h3>
                    </a>
                    <h3 data-v-59b28c75 v-if="item.title != '' && item.contentType !== 'Link'">{{item.translatedTitle || item.title}}</h3>
                    <!-- <h3 data-v-59b28c75 v-if="item.title != ''" :target="item.value.openInNewWindow ? '_blank':''" :href="(item.translatedValue && item.translatedValue.href) ? item.translatedValue.href : item.value.href" class="link">{{item.translatedTitle || item.title}}</h3> -->
                  </div>
                  <div data-v-59b28c75 class="item-type item-type-link"  v-else-if="item.contentType == 'Link'">
                    <a data-v-59b28c75 
                      v-if="item.contentType === 'Link'"  class="link" 
                      :target="item.value.openInNewWindow ? '_blank' : ''" 
                      :data-interception="item.value.openInNewWindow ? 'off' : ''" 
                      :href="(item.translatedValue && item.translatedValue.href) ? item.translatedValue.href : item.value.href"
                    >
                      {{item.translatedTitle || item.title}}
                    </a>
                    <span data-v-59b28c75 v-if="item.contentType !== 'Link'">{{item.translatedTitle || item.title}}</span>
                  </div>
                </li>
              </ul>
            </li>
          </ul>
        </li>
      </ul>
    </div>
  </transition>       
</div>
`;
    mobilemenu_vue_rollupPluginVue_script.styles = `
.mobilemenu[data-v-59b28c75] {
  font-size: 13px;
  background-color: "[theme: themeLight, default: #c7e0f4]";
  color: "[theme: neutralPrimary, default: #333]";
}
.mobilemenu .mobileTemplate .column-list[data-v-59b28c75] {
    padding: 0;
    padding-top: 10px;
    display: none;
}
.toggle-button[data-v-59b28c75] {
  cursor: pointer;
  margin: 0 calc( 50% - 24px);
}
.toggle-icon[data-v-59b28c75] {
  height: 24px;
  padding: 13px;
  display: block;
}
.toggle-icon[data-v-59b28c75]:hover {
    background-color: "[theme: themeTertiary, default: #71afe5]";
}
.foldout[data-v-59b28c75] {
  border-top: 1px solid;
  border-color: "[theme: themeTertiary, default: #71afe5]";
  position: absolute;
  top: 50px;
  z-index: 100;
  width: 100%;
  box-shadow: 0px 15px 10px -15px rgba(0, 0, 0, 0.25);
  padding-left: 0;
  padding-right: 0;
  transition: all 1s;
  background-color: "[theme: bodyBackground, default: #ffffff]";
  color: "[theme: themeDarker, default: #282c2e]";
}
.foldout.fade-enter-active[data-v-59b28c75], .foldout.fade-leave-active[data-v-59b28c75] {
    transition: transform 0.5s ease-out, opacity 0.5s ease-out;
}
.foldout.fade-enter[data-v-59b28c75], .foldout.fade-leave-to[data-v-59b28c75] {
    opacity: 0;
}
.topitem-list[data-v-59b28c75] {
  margin-top: 0;
  margin-bottom: 0px;
  padding: 0 0 0 0;
}
.topitem-listitem[data-v-59b28c75] {
  list-style: none;
  cursor: pointer;
  background-color: "[theme:neutralLighter, default: #f4f4f4]";
}
.topitem-listitem-text[data-v-59b28c75] {
  font-weight: bold;
  text-transform: uppercase;
  padding: 16px;
}
.column-list[data-v-59b28c75] {
  display: none;
  padding: 0;
  padding-top: 16px;
  background-color: "[theme:white, default: #ffffff]";
}
.active .column-list[data-v-59b28c75] {
    display: block;
}
.item-type[data-v-59b28c75] {
  margin-bottom: 16px;
}
.item-type.item-type-heading[data-v-59b28c75] {
    text-transform: uppercase;
}
.item-type.item-type-heading h3[data-v-59b28c75] {
      font-size: 1em;
      margin: 0;
      padding: 0 16px;
}
.item-type a[data-v-59b28c75] {
    display: block;
    color: "[theme: themePrimary, default: #282c2e]";
    text-decoration: none;
    padding: 0 16px;
}
.column-listitem[data-v-59b28c75] {
  list-style: none;
}
.item-list[data-v-59b28c75] {
  padding: 0px;
}
.item-listitem[data-v-59b28c75] {
  list-style: none;
}
.link-topitem[data-v-59b28c75] {
  display: block;
  font-weight: bold;
  font-size: 1em;
  margin: 0;
  padding: 0 16px;
  margin-bottom: 16px;
  text-transform: uppercase;
  color: "[theme: themePrimary, default: #282c2e]";
  text-decoration: none;
}
.link-topitem h3[data-v-59b28c75] {
    margin: 0;
}


`;

    return mobilemenu_vue_rollupPluginVue_script;

});
